﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace KursBeispiele
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        //Button zum Starten
        private void button1_Click(object sender, EventArgs e)
        {
            int sec = decimal.ToInt32( numericUpDown1.Value );

            //Die Buttons switchen
            button1.Enabled = false;
            button2.Enabled = true;

            //Starten unseren BackgroundWorker Thread - geben einen Parameter mit: sec
            backgroundWorker1.RunWorkerAsync(sec);
        }

        //Button zum Stoppen
        private void button2_Click(object sender, EventArgs e)
        {
            //Canceln den Async Process / den BackgroundWorker
            backgroundWorker1.CancelAsync();
        }

        //Dieser Teil enthält unseren eigentlichen (non-UI-Thread) Code
        private void backgroundWorker1_DoWork(object sender, DoWorkEventArgs e)
        {
            //Das Argument entsprechend verwenden
            int sec = (int)e.Argument;
            //Progress auf 0 reporten
            backgroundWorker1.ReportProgress(0);

            for (int i = sec; i > 0; i--)
            {
                //Abfragen ob der Thread abgebrochen werden soll
                if (backgroundWorker1.CancellationPending)
                {
                    e.Cancel = true;
                    return;
                }

                //eine Sekunde warten
                System.Threading.Thread.Sleep(1000);

                //Den aktuellen Progress Reporten (0..100)
                backgroundWorker1.ReportProgress(100 * (sec - i + 1) / sec);
            }
        }

        //Geht nur wenn wir die Eigenschaft ReportsProgress auf true gesetzt haben
        private void backgroundWorker1_ProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            //nutzen dieses Ereignis um den Wert der ProgressBar zu verändern
            progressBar1.Value = e.ProgressPercentage;
        }

        //Wird nach der Ausführung des BGW augerufen
        private void backgroundWorker1_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            //Die Buttons switchen
            button1.Enabled = true;
            button2.Enabled = false;

            //Machen etwas mit dem Cancelled
            if (e.Cancelled)
                MessageBox.Show("Der Thread wurde abgebrochen...");
            else
                MessageBox.Show("Thread beendet!");
        }
    }
}
